@extends('admin.setting.index')

@section('setting-content')
    <form class="col-12 col-md-9 d-flex flex-column" action="{{ route('admin.setting.update-smtp') }}" method="post">
        @csrf
        <div class="card-body">
            <h2>{{ __(key: 'SMTP') }}</h2>
             <small class="text-muted">
                {{ __("Please restart the jobs using command 'pm2 restart jobs' after making any changes to this section.") }}
            </small>

            <div class="row mb-3 mt-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Mail Mailer') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Mail Mailer. ex: smtp') }}"></i>
                        </label>
                        <input type="text" name="MAIL_MAILER" maxlength="100"
                            class="form-control @error('MAIL_MAILER') is-invalid @enderror"
                            value="{{ old('MAIL_MAILER') ?? getSetting('MAIL_MAILER') }}"
                            placeholder="{{ __('Mail Mailer') }}">
                        @error('MAIL_MAILER')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Mail Host') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Mail Host. ex: smtp.gmail.com') }}"></i>
                        </label>
                        <input type="text" name="MAIL_HOST" class="form-control @error('MAIL_HOST') is-invalid @enderror"
                            maxlength="100" value="{{ old('MAIL_HOST') ?? getSetting('MAIL_HOST') }}"
                            placeholder="{{ __('Mail Host') }}">
                        @error('MAIL_HOST')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Mail Port') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Mail Port. ex: 465') }}"></i>
                        </label>
                        <input type="number" name="MAIL_PORT" class="form-control @error('MAIL_PORT') is-invalid @enderror"
                            maxlength="100" value="{{ old('MAIL_PORT') ?? getSetting('MAIL_PORT') }}"
                            placeholder="{{ __('Mail Port') }}">
                        @error('MAIL_PORT')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Mail Username') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Mail Username. ex. admin@yourdomain.in') }}"></i>
                        </label>
                        <input type="text" name="MAIL_USERNAME"
                            class="form-control @error('MAIL_USERNAME') is-invalid @enderror" maxlength="100"
                            value="{{ old('MAIL_USERNAME') ?? getSetting('MAIL_USERNAME') }}"
                            placeholder="{{ __('Mail Username') }}">
                        @error('MAIL_USERNAME')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Mail Password') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Mail Password') }}"></i>
                        </label>
                        <input type="text" name="MAIL_PASSWORD"
                            class="form-control @error('MAIL_PASSWORD') is-invalid @enderror"
                            value="{{ isDemoMode() ? __('This field is hidden in the demo mode') : old('MAIL_PASSWORD') ?? getSetting('MAIL_PASSWORD') }}"
                            placeholder="{{ __('Mail Password') }}">
                        @error('MAIL_PASSWORD')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Mail Encryption') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Mail Encryption. ex: ssl') }}"></i>
                        </label>

                        <select class="form-control{{ $errors->has('MAIL_ENCRYPTION') ? ' is-invalid' : '' }}"
                            name="MAIL_ENCRYPTION">
                            <option value="">{{ __('Select') }}</option>
                            <option value="ssl" @if (getSetting('MAIL_ENCRYPTION') == 'ssl') selected @endif>
                                {{ __('SSL') }}
                            </option>
                            <option value="tls" @if (getSetting('MAIL_ENCRYPTION') == 'tls') selected @endif>
                                {{ __('TLS') }}
                            </option>
                            <option value="starttls" @if (getSetting('MAIL_ENCRYPTION') == 'starttls') selected @endif>
                                {{ __('STARTTLS') }}
                            </option>
                        </select>
                        @error('MAIL_ENCRYPTION')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label class="form-label">{{ __('Mail From Address') }}
                            <i class="bi bi-info-circle-fill" data-bs-toggle="tooltip" data-bs-placement="right"
                                title="{{ __('Mail From Address. ex: admin@yourdomain.in') }}"></i>
                        </label>
                        <input type="text" name="MAIL_FROM_ADDRESS" maxlength="100"
                            class="form-control @error('MAIL_FROM_ADDRESS') is-invalid @enderror"
                            value="{{ old('MAIL_FROM_ADDRESS') ?? getSetting('MAIL_FROM_ADDRESS') }}"
                            placeholder="{{ __('Mail From Address') }}">
                        @error('MAIL_FROM_ADDRESS')
                            <div class="invalid-feedback">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="bg-transparent">
                <div class="btn-list justify-content-end">
                    <button type="submit" name="submit" class="btn btn-primary">{{ __('Save') }}</button>
                </div>
            </div>
    </form>

    <hr>

    <div class="test-smtp">
        <h4>{{ __('Test SMTP') }}</h4>
        <p>{{ __('Save the above form and test the SMTP details') }}</p>

        <div id="success" class="alert alert-success d-flex align-items-center d-none" role="alert">

            <i class="fa fa-check-circle mr-3" style="font-size: 24px;"></i>
            <div>
                {{ __('An email has been sent successfully') }}
            </div>
        </div>

        <div id="error" class="alert alert-danger d-flex align-items-center d-none" role="alert">
            <i class="fa fa-exclamation-triangle mr-3" style="font-size: 24px;"></i>
            <div class="log"></div>
        </div>

        <form id="testSmtp">
            <div class="row mb-3">
                <div class="col-7 col-md-6">
                    <input id="smtpEmail" type="text" class="form-control"
                        placeholder="{{ __('Enter an email address') }}" maxlength="100" required />
                </div>
                <div class="col-5 col-md-6">
                    <button id="testSmtpButton" type="submit"
                        class="btn btn-warning ">{{ __('Send Test Email') }}</button>
                </div>
            </div>
        </form>
    </div>
@endsection
