<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ getSelectedLanguage()->direction }}"
    data-bs-theme-base="neutral" data-bs-theme="{{ getThemeFromSession() }}">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title translate="no">{{ getSetting('APPLICATION_NAME') . ' - License Fix' }}</title>
    <link rel="icon" type="image/png" href="{{ asset('storage/images/' . getSetting('FAVICON')) }}">

    <style>
        :root {
            --tblr-primary: {{ getSetting('PRIMARY_COLOR') }} !important;
            --tblr-primary: #7453f0 !important;
            --tblr-primary-rgb: 116, 83, 240 !important;
        }
    </style>

    <link href="{{ asset('/css/tabler.min.css') }}" rel="stylesheet" />

    @if (getSetting('PWA') == 'enabled')
        <link rel="manifest" href="/manifest.json">
    @endif

    <style>
        @import url("https://rsms.me/inter/inter.css");
        <link href="{{ asset('/css/bootstrap-icons.min.css') }}" rel="stylesheet" />
    </style>

</head>

<body>
    @include('include.admin.toast')
    <div class="col col-lg-6 text-center mx-auto mt-3">
        <img src="{{ asset('/storage/images/' . getSetting('PRIMARY_LOGO')) }}" width="175"
            alt="{{ __('Logo') }}" class="logo-image">
        <div class="card card-sm mt-3">
            <div class="card-body ">
                <form action="{{ route('fix-license') }}" method="POST">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">{{ __('License Fix') }}</label>
                        <small
                            class="d-block text-start mb-2 mt-3">{{ __('If you are experiencing issues with your license, or if your IP address or domain associated with the license has changed, please revalidate it by entering your license code below.') }}</small>
                        <input type="text" class="form-control @error('license_code') is-invalid @enderror"
                            name="license_code" value="{{ old('license_code') }}"
                            placeholder="{{ __('Enter your license code') }}" required minlength="19" maxlength="36">
                        @error('license_code')
                            <small class="invalid-feedback">
                                {{ $message }}
                            </small>
                        @enderror
                    </div>
                    <button type="submit" class="btn btn-primary">
                        {{ __('Fix License') }}
                    </button>
                </form>

            </div>
        </div>
    </div>
</body>
<script>
    const pwa = "{{ getSetting('PWA') }}";
</script>
<script src="{{ asset('/js/jquery.min.js') }}"></script>
<script src="{{ asset('/js/admin.js?version=') . getVersion() }}"></script>

</html>
