//add headers to all the ajax requests
$.ajaxSetup({
  headers: {
    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
  },
});

$(document).ready(function () {

  $('.dark-theme-setting').on('click', function () {
    const currentTheme = document.documentElement.getAttribute('data-bs-theme');
    if (currentTheme === 'light') {
      document.documentElement.setAttribute('data-bs-theme', 'dark');
      localStorage.setItem('theme', 'dark');
      $('#moonIcon').hide();
      $('#sunIcon').show();
    } else {
      document.documentElement.setAttribute('data-bs-theme', 'light');
      localStorage.setItem('theme', 'light');
      $('#sunIcon').hide();
      $('#moonIcon').show();
    }
  });


  $(".jm-toggle-password").on("click", function () {
    const passwordInput = $(this)
      .closest(".input-group")
      .find('input[type="password"], input[type="text"]');

    if (passwordInput.attr("type") === "password") {
      passwordInput.attr("type", "text");
      $(this).html(`
                  <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                       viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                       stroke-linecap="round" stroke-linejoin="round">
                      <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                      <path d="M3 3l18 18" />
                      <path d="M10.584 10.587a2 2 0 0 0 2.828 2.83" />
                      <path d="M9.363 5.365a9.466 9.466 0 0 1 2.637 -.365c3.6 0 6.6 2 9 6c-.612 1.02 -1.314 1.918 -2.099 2.695" />
                      <path d="M21 12c-2.4 4 -5.4 6 -9 6c-1.488 0 -2.914 -.344 -4.243 -1.031" />
                  </svg>
              `);
    } else {
      passwordInput.attr("type", "password");
      $(this).html(`
                  <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                       viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                       stroke-linecap="round" stroke-linejoin="round">
                      <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                      <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                      <path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                  </svg>
              `);
    }
  });

  $("#autoLogin").on("change", function () {
    let email;

    if (this.value == "admin") {
      email = "admin@thertclabs.com";
    } else if (this.value == "user_1") {
      email = "user1@thertclabs.com";
    } else if (this.value == "user_2") {
      email = "user2@thertclabs.com";
    }

    $("#loginButton").attr("disabled", true);

    $("#email").val(email);
    $("#password").val("12345678");
    $("#loginForm").trigger("submit");
  });

  if ($("#toast-simple").is(":visible")) {
    setTimeout(() => {
      $("#toast-simple").fadeOut();
      $("#toast-simple").removeClass("show");
    }, 3000);
  }


  //check if the cookie is accepted
  if (cookieConsent == "enabled" && !localStorage.getItem("cookieAccepted")) {
    setTimeout(function () {
      $(".cookie").addClass("show");
    }, 3000);
  }

  //store in the local storage and hide the cookie dialogue
  $(document).on("click", ".confirm-cookie", function () {
    localStorage.setItem("cookieAccepted", true);
    $(".cookie").removeClass("show");
  });

  //dynamically add google analytics tracking ID
  if (googleAnalyticsTrackingId !== "null" && googleAnalyticsTrackingId) {
    let script = document.createElement("script");
    script.src =
      "https://www.googletagmanager.com/gtag/js?id=" +
      googleAnalyticsTrackingId;
    document.body.appendChild(script);

    window.dataLayer = window.dataLayer || [];

    function gtag() {
      dataLayer.push(arguments);
    }
    gtag("js", new Date());
    gtag("config", googleAnalyticsTrackingId);
  }

  //PWA
  if (pwa == 'enabled') {
    let deferredPrompt;

    window.addEventListener("beforeinstallprompt", (e) => {
      e.preventDefault();

      if (!localStorage.getItem("dontWantToInstall")) {
        $("#installationModal").modal("show");
      }

      deferredPrompt = e;
    });

    document.getElementById("installApp").addEventListener("click", () => {
      $("#installationModal").modal("hide");
      deferredPrompt.prompt();
    });

    document
      .getElementById("closeInstallationModal")
      .addEventListener("click", () => {
        localStorage.setItem("dontWantToInstall", "true");
        $("#installationModal").modal("hide");
      });
  }

  $("#meetingDashboard").on("submit", function (e) {
    e.preventDefault();

    if (conferenceId.value.length <= 3) {
      showToast(languages.no_meeting);
      return;
    }

    $("#join").attr("disabled", true);

    $.ajax({
      url: "/check-meeting",
      data: htmlEscapeArray($(this).serializeArray()),
      type: "post",
    })
      .done(function (data) {
        data = JSON.parse(data);
        $("#join").attr("disabled", false);

        if (data.success) {
          location.href = "meeting/" + data.id;
        } else {
          showToast(languages.no_meeting);
        }
      })
      .catch(function () {
        showToast(languages.no_meeting);
        $("#join").attr("disabled", false);
      });
  });

  //to prevent XSS vulnerability
  function htmlEscapeArray(input) {
    let data = {};
    $.each(input, function () {
      data[this.name] = this.value
        .replace(/&/g, "")
        .replace(/"/g, "")
        .replace(/'/g, "")
        .replace(/</g, "")
        .replace(/>/g, "");
    });
    return data;
  }

  if (window.location.pathname == '/') {
    $("#monthlyBtn").click(function () {
      $(this).addClass("active");
      $("#yearlyBtn").removeClass("active");

      $(".plan-month").removeClass("d-none");
      $(".plan-year").addClass("d-none");
    });

    $("#yearlyBtn").click(function () {
      $(this).addClass("active");
      $("#monthlyBtn").removeClass("active");

      $(".plan-year").removeClass("d-none");
      $(".plan-month").addClass("d-none");
    });

    $("#monthlyBtn").click();
  }

  // -------------------Loader JS-------------------

  $('.hideLoader').click(function () {
    $("#cover-spin").show();
    setTimeout(function () {
      $("#cover-spin").hide();
    }, 2000);
  });
});

$(window).on("load", function () {
  $("#cover-spin").hide();
});

$(window).on('beforeunload', function () {
  $("#cover-spin").show();
});

// When page is restored from bfcache (back/forward button)
window.addEventListener('pageshow', function (event) {
  if (event.persisted) {
    $("#cover-spin").hide();
  }
});

//make sure this document is always at top due to media permission
if (window != top) top.location.href = window.location.href;

//handle remove copoun
$("#remove_coupon").on("click", function (e) {
  $('input[name="coupon"]').val('');
  //remove the submit button
  document.querySelector('#form-payment').submit.remove();

  //submit the form
  document.querySelector('#form-payment').submit();
});

//update summary
let updateSummary = (type) => {
  if (type == 'month') {
    document.querySelectorAll('.checkout-month').forEach(function (element) {
      element.classList.add('d-inline-block');
    });
    document.querySelectorAll('.checkout-month').forEach(function (element) {
      element.classList.remove('d-none');
    });
    document.querySelectorAll('.checkout-year').forEach(function (element) {
      element.classList.remove('d-inline-block');
    });
    document.querySelectorAll('.checkout-year').forEach(function (element) {
      element.classList.add('d-none');
    });

    $(".month-label").addClass("active");
    $(".year-label").removeClass("active");

  } else {
    document.querySelectorAll('.checkout-month').forEach(function (element) {
      element.classList.remove('d-inline-block');
    });
    document.querySelectorAll('.checkout-year').forEach(function (element) {
      element.classList.add('d-inline-block');
    });
    document.querySelectorAll('.checkout-year').forEach(function (element) {
      element.classList.remove('d-none');
    });
    document.querySelectorAll('.checkout-month').forEach(function (element) {
      element.classList.add('d-none');
    });

    $(".year-label").addClass("active");
    $(".month-label").removeClass("active");

  }
};

//update billing type
let updateBillingType = (value) => {
  document.querySelectorAll('.checkout-subscription').forEach(function (element) {
    element.classList.remove('d-none');
  });
  document.querySelectorAll('.checkout-subscription').forEach(function (element) {
    element.classList.add('d-block');
  });
}

//payment form
if (document.querySelector('#form-payment')) {
  let url = new URL(window.location.href);

  document.querySelectorAll('[name="interval"]').forEach(function (element) {
    if (element.checked) {
      updateSummary(element.value);
    }

    //listen to interval changes
    element.addEventListener('change', function () {
      url.searchParams.set('interval', element.value);
      history.pushState(null, null, url.href);
      updateSummary(element.value);
    });
  });

  document.querySelectorAll('[name="payment_gateway"]').forEach(function (element) {
    if (element.checked) {
      updateBillingType(element.value);
    }

    //listen to payment gateway changes
    element.addEventListener('change', function () {
      url.searchParams.set('payment', element.value);
      history.pushState(null, null, url.href);
      updateBillingType(element.value);
    });
  });

  //if the Add a coupon button is clicked
  document.querySelector('#coupon') && document.querySelector('#coupon').addEventListener('click', function (e) {
    e.preventDefault();

    this.classList.add('d-none');
    document.querySelector('#coupon-input').classList.remove('d-none');
    document.querySelector('input[name="coupon"]').removeAttribute('disabled');
  });

  //if the Cancel coupon button is clicked
  document.querySelector('#coupon-cancel') && document.querySelector('#coupon-cancel').addEventListener('click', function (e) {
    e.preventDefault();

    document.querySelector('#coupon').classList.remove('d-none');
    document.querySelector('#coupon-input').classList.add('d-none');
    document.querySelector('input[name="coupon"]').setAttribute('disabled', 'disabled');
  });

  //if the country value changes
  document.querySelector('#i-country').addEventListener('change', function () {
    document.querySelector('#form-payment').submit.remove();
    document.querySelector('#form-payment').submit();
  });
}

//handle plan month click
document.querySelector('#plan-month') && document.querySelector('#plan-month').addEventListener("click", function () {
  document.querySelectorAll('.plan-month').forEach(element => element.classList.add('d-block'));
  document.querySelectorAll('.plan-year').forEach(element => element.classList.remove('d-block'));
});

//handle plan year click
document.querySelector('#plan-year') && document.querySelector('#plan-year').addEventListener("click", function () {
  document.querySelectorAll('.plan-year').forEach(element => element.classList.add('d-block'));
  document.querySelectorAll('.plan-month').forEach(element => element.classList.remove('d-block', 'plan-preload'));
});

//apply theme to the Google reCAPTCHA
if (document.querySelector('.g-recaptcha')) {
  document.querySelector('.g-recaptcha').setAttribute("data-theme", document.documentElement.getAttribute(
    'data-bs-theme'));
}

function showToast(message, type = "success") {
  const toast = $("#toast-simple");
  const toastBody = toast.find(".toast-body");

  toastBody.text(message || "An error occurred, please try again!");

  toast.removeClass("bg-success").addClass("show");

  toast.fadeIn();

  setTimeout(() => {
    toast.fadeOut();
    toast.removeClass("show");
  }, 3000);
}

//set href into the social links
var fullUrl = location.protocol + '//' + location.hostname + location.pathname; // Full current URL
$('#fbShare').attr('href', 'https://www.facebook.com/sharer/sharer.php?u=' + encodeURIComponent(fullUrl) + '&quote=' + encodeURIComponent(socialInvitation));
// $('#fbShare').attr('href', 'https://www.facebook.com/sharer/sharer.php?u=' + location.hostname + '&quote=' + socialInvitation);
$('#twitterShare').attr('href', 'https://twitter.com/share?url=' + location.hostname + '&text=' + socialInvitation);
$('#waShare').attr('href', 'https://api.whatsapp.com/send?text=' + socialInvitation + ' \n ' + location.hostname);

// Check if the user is authenticated
if (authUser) {

  // Ping user activity status every 30 seconds
  function pingUserActivityStatus() {
    const data = new FormData();
    data.append('_token', $('meta[name="csrf-token"]').attr('content'));
    navigator.sendBeacon("/user-activity-status", data);
  }

  // Initial ping when the script loads
  pingUserActivityStatus();

  // Set an interval to ping every 30 seconds
  setInterval(pingUserActivityStatus, 30 * 1000);
} 
