<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('code')->unique();
            $table->timestamps();
        });

        DB::table('countries')->insert([
            ['id' => 1, 'name' => 'Andorra', 'code' => 'ad'],
            ['id' => 2, 'name' => 'United Arab Emirates', 'code' => 'ae'],
            ['id' => 3, 'name' => 'Afghanistan', 'code' => 'af'],
            ['id' => 4, 'name' => 'Antigua and Barbuda', 'code' => 'ag'],
            ['id' => 5, 'name' => 'Anguilla', 'code' => 'ai'],
            ['id' => 6, 'name' => 'Albania', 'code' => 'al'],
            ['id' => 7, 'name' => 'Armenia', 'code' => 'am'],
            ['id' => 8, 'name' => 'Angola', 'code' => 'ao'],
            ['id' => 9, 'name' => 'Antarctica', 'code' => 'aq'],
            ['id' => 10, 'name' => 'Argentina', 'code' => 'ar'],
            ['id' => 11, 'name' => 'American Samoa', 'code' => 'as'],
            ['id' => 12, 'name' => 'Austria', 'code' => 'at'],
            ['id' => 13, 'name' => 'Australia', 'code' => 'au'],
            ['id' => 14, 'name' => 'Aruba', 'code' => 'aw'],
            ['id' => 15, 'name' => 'Åland Islands', 'code' => 'ax'],
            ['id' => 16, 'name' => 'Azerbaijan', 'code' => 'az'],
            ['id' => 17, 'name' => 'Bosnia and Herzegovina', 'code' => 'ba'],
            ['id' => 18, 'name' => 'Barbados', 'code' => 'bb'],
            ['id' => 19, 'name' => 'Bangladesh', 'code' => 'bd'],
            ['id' => 20, 'name' => 'Belgium', 'code' => 'be'],
            ['id' => 21, 'name' => 'Burkina Faso', 'code' => 'bf'],
            ['id' => 22, 'name' => 'Bulgaria', 'code' => 'bg'],
            ['id' => 23, 'name' => 'Bahrain', 'code' => 'bh'],
            ['id' => 24, 'name' => 'Burundi', 'code' => 'bi'],
            ['id' => 25, 'name' => 'Benin', 'code' => 'bj'],
            ['id' => 26, 'name' => 'Saint Barthélemy', 'code' => 'bl'],
            ['id' => 27, 'name' => 'Bermuda', 'code' => 'bm'],
            ['id' => 28, 'name' => 'Brunei Darussalam', 'code' => 'bn'],
            ['id' => 29, 'name' => 'Bolivia, Plurinational State of', 'code' => 'bo'],
            ['id' => 30, 'name' => 'Bonaire, Sint Eustatius and Saba', 'code' => 'bq-bo'],
            ['id' => 31, 'name' => 'Bonaire, Sint Eustatius and Saba', 'code' => 'bq-sa'],
            ['id' => 32, 'name' => 'Bonaire, Sint Eustatius and Saba', 'code' => 'bq-se'],
            ['id' => 33, 'name' => 'Brazil', 'code' => 'br'],
            ['id' => 34, 'name' => 'Bahamas', 'code' => 'bs'],
            ['id' => 35, 'name' => 'Bhutan', 'code' => 'bt'],
            ['id' => 36, 'name' => 'Bouvet Island', 'code' => 'bv'],
            ['id' => 37, 'name' => 'Botswana', 'code' => 'bw'],
            ['id' => 38, 'name' => 'Belarus', 'code' => 'by'],
            ['id' => 39, 'name' => 'Belize', 'code' => 'bz'],
            ['id' => 40, 'name' => 'Canada', 'code' => 'ca'],
            ['id' => 41, 'name' => 'Cocos (Keeling) Islands', 'code' => 'cc'],
            ['id' => 42, 'name' => 'Congo, The Democratic Republic of the', 'code' => 'cd'],
            ['id' => 43, 'name' => 'Central African Republic', 'code' => 'cf'],
            ['id' => 44, 'name' => 'Congo', 'code' => 'cg'],
            ['id' => 45, 'name' => 'Switzerland', 'code' => 'ch'],
            ['id' => 46, 'name' => 'Côte dIvoire', 'code' => 'ci'],
            ['id' => 47, 'name' => 'Cook Islands', 'code' => 'ck'],
            ['id' => 48, 'name' => 'Chile', 'code' => 'cl'],
            ['id' => 49, 'name' => 'Cameroon', 'code' => 'cm'],
            ['id' => 50, 'name' => 'China', 'code' => 'cn'],
            ['id' => 51, 'name' => 'Colombia', 'code' => 'co'],
            ['id' => 52, 'name' => 'Costa Rica', 'code' => 'cr'],
            ['id' => 53, 'name' => 'Cuba', 'code' => 'cu'],
            ['id' => 54, 'name' => 'Cabo Verde', 'code' => 'cv'],
            ['id' => 55, 'name' => 'Curaçao', 'code' => 'cw'],
            ['id' => 56, 'name' => 'Christmas Island', 'code' => 'cx'],
            ['id' => 57, 'name' => 'Cyprus', 'code' => 'cy'],
            ['id' => 58, 'name' => 'Czechia', 'code' => 'cz'],
            ['id' => 59, 'name' => 'Germany', 'code' => 'de'],
            ['id' => 60, 'name' => 'Djibouti', 'code' => 'dj'],
            ['id' => 61, 'name' => 'Denmark', 'code' => 'dk'],
            ['id' => 62, 'name' => 'Dominica', 'code' => 'dm'],
            ['id' => 63, 'name' => 'Dominican Republic', 'code' => 'do'],
            ['id' => 64, 'name' => 'Algeria', 'code' => 'dz'],
            ['id' => 65, 'name' => 'Ecuador', 'code' => 'ec'],
            ['id' => 66, 'name' => 'Estonia', 'code' => 'ee'],
            ['id' => 67, 'name' => 'Egypt', 'code' => 'eg'],
            ['id' => 68, 'name' => 'Western Sahara', 'code' => 'eh'],
            ['id' => 69, 'name' => 'Eritrea', 'code' => 'er'],
            ['id' => 70, 'name' => 'Spain', 'code' => 'es'],
            ['id' => 71, 'name' => 'Ethiopia', 'code' => 'et'],
            ['id' => 72, 'name' => 'European Union', 'code' => 'eu'],
            ['id' => 73, 'name' => 'Finland', 'code' => 'fi'],
            ['id' => 74, 'name' => 'Fiji', 'code' => 'fj'],
            ['id' => 75, 'name' => 'Falkland Islands (Malvinas)', 'code' => 'fk'],
            ['id' => 76, 'name' => 'Micronesia, Federated States of', 'code' => 'fm'],
            ['id' => 77, 'name' => 'Faroe Islands', 'code' => 'fo'],
            ['id' => 78, 'name' => 'France', 'code' => 'fr'],
            ['id' => 79, 'name' => 'Gabon', 'code' => 'ga'],
            ['id' => 80, 'name' => 'United Kingdom', 'code' => 'gb-eng'],
            ['id' => 81, 'name' => 'United Kingdom', 'code' => 'gb-nir'],
            ['id' => 82, 'name' => 'United Kingdom', 'code' => 'gb-sct'],
            ['id' => 83, 'name' => 'United Kingdom', 'code' => 'gb-wls'],
            ['id' => 84, 'name' => 'United Kingdom', 'code' => 'gb'],
            ['id' => 85, 'name' => 'Grenada', 'code' => 'gd'],
            ['id' => 86, 'name' => 'Georgia', 'code' => 'ge'],
            ['id' => 87, 'name' => 'French Guiana', 'code' => 'gf'],
            ['id' => 88, 'name' => 'Guernsey', 'code' => 'gg'],
            ['id' => 89, 'name' => 'Ghana', 'code' => 'gh'],
            ['id' => 90, 'name' => 'Gibraltar', 'code' => 'gi'],
            ['id' => 91, 'name' => 'Greenland', 'code' => 'gl'],
            ['id' => 92, 'name' => 'Gambia', 'code' => 'gm'],
            ['id' => 93, 'name' => 'Guinea', 'code' => 'gn'],
            ['id' => 94, 'name' => 'Guadeloupe', 'code' => 'gp'],
            ['id' => 95, 'name' => 'Equatorial Guinea', 'code' => 'gq'],
            ['id' => 96, 'name' => 'Greece', 'code' => 'gr'],
            ['id' => 97, 'name' => 'South Georgia and the South Sandwich Islands', 'code' => 'gs'],
            ['id' => 98, 'name' => 'Guatemala', 'code' => 'gt'],
            ['id' => 99, 'name' => 'Guam', 'code' => 'gu'],
            ['id' => 100, 'name' => 'Guinea-Bissau', 'code' => 'gw'],
            ['id' => 101, 'name' => 'Guyana', 'code' => 'gy'],
            ['id' => 102, 'name' => 'Hong Kong', 'code' => 'hk'],
            ['id' => 103, 'name' => 'Heard Island and McDonald Islands', 'code' => 'hm'],
            ['id' => 104, 'name' => 'Honduras', 'code' => 'hn'],
            ['id' => 105, 'name' => 'Croatia', 'code' => 'hr'],
            ['id' => 106, 'name' => 'Haiti', 'code' => 'ht'],
            ['id' => 107, 'name' => 'Hungary', 'code' => 'hu'],
            ['id' => 108, 'name' => 'Indonesia', 'code' => 'id'],
            ['id' => 109, 'name' => 'Ireland', 'code' => 'ie'],
            ['id' => 110, 'name' => 'Israel', 'code' => 'il'],
            ['id' => 111, 'name' => 'Isle of Man', 'code' => 'im'],
            ['id' => 112, 'name' => 'India', 'code' => 'in'],
            ['id' => 113, 'name' => 'British Indian Ocean Territory', 'code' => 'io'],
            ['id' => 114, 'name' => 'Iraq', 'code' => 'iq'],
            ['id' => 115, 'name' => 'Iran, Islamic Republic of', 'code' => 'ir'],
            ['id' => 116, 'name' => 'Iceland', 'code' => 'is'],
            ['id' => 117, 'name' => 'Italy', 'code' => 'it'],
            ['id' => 118, 'name' => 'Jersey', 'code' => 'je'],
            ['id' => 119, 'name' => 'Jamaica', 'code' => 'jm'],
            ['id' => 120, 'name' => 'Jordan', 'code' => 'jo'],
            ['id' => 121, 'name' => 'Japan', 'code' => 'jp'],
            ['id' => 122, 'name' => 'Kenya', 'code' => 'ke'],
            ['id' => 123, 'name' => 'Kyrgyzstan', 'code' => 'kg'],
            ['id' => 124, 'name' => 'Cambodia', 'code' => 'kh'],
            ['id' => 125, 'name' => 'Kiribati', 'code' => 'ki'],
            ['id' => 126, 'name' => 'Comoros', 'code' => 'km'],
            ['id' => 127, 'name' => 'Saint Kitts and Nevis', 'code' => 'kn-sk'],
            ['id' => 128, 'name' => 'Saint Kitts and Nevis', 'code' => 'kn'],
            ['id' => 129, 'name' => 'Korea, Democratic Peoples Republic of', 'code' => 'kp'],
            ['id' => 130, 'name' => 'Korea, Republic of', 'code' => 'kr'],
            ['id' => 131, 'name' => 'Kuwait', 'code' => 'kw'],
            ['id' => 132, 'name' => 'Cayman Islands', 'code' => 'ky'],
            ['id' => 133, 'name' => 'Kazakhstan', 'code' => 'kz'],
            ['id' => 134, 'name' => 'Lao Peoples Democratic Republic', 'code' => 'la'],
            ['id' => 135, 'name' => 'Lebanon', 'code' => 'lb'],
            ['id' => 136, 'name' => 'Saint Lucia', 'code' => 'lc'],
            ['id' => 137, 'name' => 'Liechtenstein', 'code' => 'li'],
            ['id' => 138, 'name' => 'Sri Lanka', 'code' => 'lk'],
            ['id' => 139, 'name' => 'Liberia', 'code' => 'lr'],
            ['id' => 140, 'name' => 'Lesotho', 'code' => 'ls'],
            ['id' => 141, 'name' => 'Lithuania', 'code' => 'lt'],
            ['id' => 142, 'name' => 'Luxembourg', 'code' => 'lu'],
            ['id' => 143, 'name' => 'Latvia', 'code' => 'lv'],
            ['id' => 144, 'name' => 'Libya', 'code' => 'ly'],
            ['id' => 145, 'name' => 'Morocco', 'code' => 'ma'],
            ['id' => 146, 'name' => 'Monaco', 'code' => 'mc'],
            ['id' => 147, 'name' => 'Moldova, Republic of', 'code' => 'md'],
            ['id' => 148, 'name' => 'Montenegro', 'code' => 'me'],
            ['id' => 149, 'name' => 'Saint Martin (French part)', 'code' => 'mf'],
            ['id' => 150, 'name' => 'Madagascar', 'code' => 'mg'],
            ['id' => 151, 'name' => 'Marshall Islands', 'code' => 'mh'],
            ['id' => 152, 'name' => 'North Macedonia', 'code' => 'mk'],
            ['id' => 153, 'name' => 'Mali', 'code' => 'ml'],
            ['id' => 154, 'name' => 'Myanmar', 'code' => 'mm'],
            ['id' => 155, 'name' => 'Mongolia', 'code' => 'mn'],
            ['id' => 156, 'name' => 'Macao', 'code' => 'mo'],
            ['id' => 157, 'name' => 'Northern Mariana Islands', 'code' => 'mp'],
            ['id' => 158, 'name' => 'Martinique', 'code' => 'mq'],
            ['id' => 159, 'name' => 'Mauritania', 'code' => 'mr'],
            ['id' => 160, 'name' => 'Montserrat', 'code' => 'ms'],
            ['id' => 161, 'name' => 'Malta', 'code' => 'mt'],
            ['id' => 162, 'name' => 'Mauritius', 'code' => 'mu'],
            ['id' => 163, 'name' => 'Maldives', 'code' => 'mv'],
            ['id' => 164, 'name' => 'Malawi', 'code' => 'mw'],
            ['id' => 165, 'name' => 'Mexico', 'code' => 'mx'],
            ['id' => 166, 'name' => 'Malaysia', 'code' => 'my'],
            ['id' => 167, 'name' => 'Mozambique', 'code' => 'mz'],
            ['id' => 168, 'name' => 'Namibia', 'code' => 'na'],
            ['id' => 169, 'name' => 'New Caledonia', 'code' => 'nc'],
            ['id' => 170, 'name' => 'Niger', 'code' => 'ne'],
            ['id' => 171, 'name' => 'Norfolk Island', 'code' => 'nf'],
            ['id' => 172, 'name' => 'Nigeria', 'code' => 'ng'],
            ['id' => 173, 'name' => 'Nicaragua', 'code' => 'ni'],
            ['id' => 174, 'name' => 'Netherlands', 'code' => 'nl'],
            ['id' => 175, 'name' => 'Norway', 'code' => 'no'],
            ['id' => 176, 'name' => 'Nepal', 'code' => 'np'],
            ['id' => 177, 'name' => 'Nauru', 'code' => 'nr'],
            ['id' => 178, 'name' => 'Niue', 'code' => 'nu'],
            ['id' => 179, 'name' => 'New Zealand', 'code' => 'nz'],
            ['id' => 180, 'name' => 'Oman', 'code' => 'om'],
            ['id' => 181, 'name' => 'Panama', 'code' => 'pa'],
            ['id' => 182, 'name' => 'Peru', 'code' => 'pe'],
            ['id' => 183, 'name' => 'French Polynesia', 'code' => 'pf'],
            ['id' => 184, 'name' => 'Papua New Guinea', 'code' => 'pg'],
            ['id' => 185, 'name' => 'Philippines', 'code' => 'ph'],
            ['id' => 186, 'name' => 'Pakistan', 'code' => 'pk'],
            ['id' => 187, 'name' => 'Poland', 'code' => 'pl'],
            ['id' => 188, 'name' => 'Saint Pierre and Miquelon', 'code' => 'pm'],
            ['id' => 189, 'name' => 'Pitcairn', 'code' => 'pn'],
            ['id' => 190, 'name' => 'Puerto Rico', 'code' => 'pr'],
            ['id' => 191, 'name' => 'Palestine, State of', 'code' => 'ps'],
            ['id' => 192, 'name' => 'Portugal', 'code' => 'pt'],
            ['id' => 193, 'name' => 'Palau', 'code' => 'pw'],
            ['id' => 194, 'name' => 'Paraguay', 'code' => 'py'],
            ['id' => 195, 'name' => 'Qatar', 'code' => 'qa'],
            ['id' => 196, 'name' => 'Rainbow Nation', 'code' => 'rainbow'],
            ['id' => 197, 'name' => 'Réunion', 'code' => 're'],
            ['id' => 198, 'name' => 'Romania', 'code' => 'ro'],
            ['id' => 199, 'name' => 'Serbia', 'code' => 'rs'],
            ['id' => 200, 'name' => 'Russian Federation', 'code' => 'ru'],
            ['id' => 201, 'name' => 'Rwanda', 'code' => 'rw'],
            ['id' => 202, 'name' => 'Saudi Arabia', 'code' => 'sa'],
            ['id' => 203, 'name' => 'Solomon Islands', 'code' => 'sb'],
            ['id' => 204, 'name' => 'Seychelles', 'code' => 'sc'],
            ['id' => 205, 'name' => 'Sudan', 'code' => 'sd'],
            ['id' => 206, 'name' => 'Sweden', 'code' => 'se'],
            ['id' => 207, 'name' => 'Singapore', 'code' => 'sg'],
            ['id' => 208, 'name' => 'Saint Helena, Ascension and Tristan da Cunha', 'code' => 'sh'],
            ['id' => 209, 'name' => 'Slovenia', 'code' => 'si'],
            ['id' => 210, 'name' => 'Svalbard and Jan Mayen', 'code' => 'sj'],
            ['id' => 211, 'name' => 'Slovakia', 'code' => 'sk'],
            ['id' => 212, 'name' => 'Sierra Leone', 'code' => 'sl'],
            ['id' => 213, 'name' => 'San Marino', 'code' => 'sm'],
            ['id' => 214, 'name' => 'Senegal', 'code' => 'sn'],
            ['id' => 215, 'name' => 'Somalia', 'code' => 'so'],
            ['id' => 216, 'name' => 'Suriname', 'code' => 'sr'],
            ['id' => 217, 'name' => 'South Sudan', 'code' => 'ss'],
            ['id' => 218, 'name' => 'Sao Tome and Principe', 'code' => 'st'],
            ['id' => 219, 'name' => 'El Salvador', 'code' => 'sv'],
            ['id' => 220, 'name' => 'Sint Maarten (Dutch part)', 'code' => 'sx'],
            ['id' => 221, 'name' => 'Syrian Arab Republic', 'code' => 'sy'],
            ['id' => 222, 'name' => 'Eswatini', 'code' => 'sz'],
            ['id' => 223, 'name' => 'Turks and Caicos Islands', 'code' => 'tc'],
            ['id' => 224, 'name' => 'Chad', 'code' => 'td'],
            ['id' => 225, 'name' => 'French Southern Territories', 'code' => 'tf'],
            ['id' => 226, 'name' => 'Togo', 'code' => 'tg'],
            ['id' => 227, 'name' => 'Thailand', 'code' => 'th'],
            ['id' => 228, 'name' => 'Tajikistan', 'code' => 'tj'],
            ['id' => 229, 'name' => 'Tokelau', 'code' => 'tk'],
            ['id' => 230, 'name' => 'Timor-Leste', 'code' => 'tl'],
            ['id' => 231, 'name' => 'Turkmenistan', 'code' => 'tm'],
            ['id' => 232, 'name' => 'Tunisia', 'code' => 'tn'],
            ['id' => 233, 'name' => 'Tonga', 'code' => 'to'],
            ['id' => 234, 'name' => 'Turkey', 'code' => 'tr'],
            ['id' => 235, 'name' => 'Trinidad and Tobago', 'code' => 'tt'],
            ['id' => 236, 'name' => 'Tuvalu', 'code' => 'tv'],
            ['id' => 237, 'name' => 'Taiwan, Province of China', 'code' => 'tw'],
            ['id' => 238, 'name' => 'Tanzania, United Republic of', 'code' => 'tz'],
            ['id' => 239, 'name' => 'Ukraine', 'code' => 'ua'],
            ['id' => 240, 'name' => 'Uganda', 'code' => 'ug'],
            ['id' => 241, 'name' => 'United States Minor Outlying Islands', 'code' => 'um'],
            ['id' => 242, 'name' => 'Union of South American Nations', 'code' => 'unasur'],
            ['id' => 243, 'name' => 'United States', 'code' => 'us'],
            ['id' => 244, 'name' => 'Uruguay', 'code' => 'uy'],
            ['id' => 245, 'name' => 'Uzbekistan', 'code' => 'uz'],
            ['id' => 246, 'name' => 'Holy See (Vatican City State)', 'code' => 'va'],
            ['id' => 247, 'name' => 'Saint Vincent and the Grenadines', 'code' => 'vc'],
            ['id' => 248, 'name' => 'Venezuela, Bolivarian Republic of', 'code' => 've'],
            ['id' => 249, 'name' => 'Virgin Islands, British', 'code' => 'vg'],
            ['id' => 250, 'name' => 'Virgin Islands, U.S.', 'code' => 'vi'],
            ['id' => 251, 'name' => 'Viet Nam', 'code' => 'vn'],
            ['id' => 252, 'name' => 'Vanuatu', 'code' => 'vu'],
            ['id' => 253, 'name' => 'Wallis and Futuna', 'code' => 'wf'],
            ['id' => 254, 'name' => 'Samoa', 'code' => 'ws'],
            ['id' => 255, 'name' => 'Yemen', 'code' => 'ye'],
            ['id' => 256, 'name' => 'Mayotte', 'code' => 'yt'],
            ['id' => 257, 'name' => 'South Africa', 'code' => 'za'],
            ['id' => 258, 'name' => 'Zambia', 'code' => 'zm'],
            ['id' => 259, 'name' => 'Zimbabwe', 'code' => 'zw'],
        ]);
    }

    public function down(): void
    {
        Schema::dropIfExists('countries');
    }
};
